package com.twentyfouri.tvlauncher.setupwizard

import android.view.inputmethod.EditorInfo
import com.twentyfouri.phoenixapi.data.ErrorCodes
import com.twentyfouri.smartmodel.model.user.SmartLoginCredentials
import com.twentyfouri.smartmodel.model.user.SmartUserProfileReference
import com.twentyfouri.smartmodel.phoenix.model.user.PhoenixLoginCredentialsPassword
import com.twentyfouri.smartmodel.phoenix.model.user.PhoenixLoginCredentialsPin
import com.twentyfouri.smartmodel.phoenix.referencemodels.PhoenixUserProfileReference
import com.twentyfouri.smartmodel.serialization.SmartDataObject
import com.twentyfouri.tvlauncher.common.data.ResourceRepository
import com.twentyfouri.tvlauncher.setupwizard.basesetup.BaseSetupModel
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.Screens
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.models.*

class Flavor : FlavorBase() {

    override val usernameScreenList = listOf(
        Screens.InitialScreen,
        Screens.UsernameScreen,
        Screens.PasswordScreen,
        Screens.CaptchaScreen
    )

    override val pinScreenList = listOf(
        Screens.InitialScreen,
        Screens.PinScreen
    )

    override fun getLoginCredentialsType(loginCredentials: LoginCredentials): SmartLoginCredentials {
        return if (loginCredentials.username != null && loginCredentials.password != null) {
            PhoenixLoginCredentialsPassword(loginCredentials.username.orEmpty(), loginCredentials.password.orEmpty(), PhoenixLoginCredentialsPassword.HouseholdType.FULL_CHECK)
        } else {
            PhoenixLoginCredentialsPin(loginCredentials.pin)
        }
    }

    override fun getImeAction(currentScreen: Screens, screens: List<Screens>): Int {
        return if (currentScreen == screens.last()) EditorInfo.IME_ACTION_DONE
        else EditorInfo.IME_ACTION_NEXT
    }

    override fun getUserProfileReference(userName: String): SmartUserProfileReference {
        return PhoenixUserProfileReference(userName)
    }

    override fun gdprProfileChangeObject(isGdrpAccepted: Boolean?): SmartDataObject {
//        return SmartDataObject(Pair(EnvisionProfileMapper.GDPR_KEY, !isGdrpAccepted))
        return SmartDataObject(Pair("", false))
    }

    override fun isGdprAcceptedProfile(extras: SmartDataObject, modelRecommendations: Boolean): Boolean {
//        return extras.getBoolean(EnvisionProfileMapper.GDPR_KEY, false)
        return false == modelRecommendations
    }

    fun processErrorMessage(code: String, resourceRepository: ResourceRepository): String = getErrorMessage(code,resourceRepository)

    private fun getErrorMessage(code: String, resourceRepository: ResourceRepository):String{
        return when (code){
            ErrorCodes.USER_NOT_IN_DOMAIN.toString() -> resourceRepository.getString(R.string.user_not_in_domain, code)
            ErrorCodes.DEVICE_NOT_IN_DOMAIN.toString() -> resourceRepository.getString(R.string.device_not_in_domain, code)
            ErrorCodes.HOUSEHOLD_DEVICE_EXIST.toString() -> resourceRepository.getString(R.string.household_device_exists, code)
            ErrorCodes.USER_EXISTS_IN_OTHER_DOMAINS.toString() -> resourceRepository.getString(R.string.user_exists_in_other_domains, code)
            ErrorCodes.HOME_NETWORK_LIMITATIONS.toString() -> resourceRepository.getString(R.string.home_network_limitations, code)
            ErrorCodes.SECRET_IS_WRONG.toString() -> resourceRepository.getString(R.string.secret_is_wrong)
            ErrorCodes.LOGIN_VIA_PIN_NOT_ALLOWED.toString() -> resourceRepository.getString(R.string.login_via_pin_not_allowed, code)
            ErrorCodes.INSIDE_LOCK_TIME.toString() -> resourceRepository.getString(R.string.inside_lock_time, code)
            ErrorCodes.USER_NOT_ACTIVATED.toString(),ErrorCodes.USER_ALREADY_LOGGED_IN.toString() -> resourceRepository.getString(
                            R.string.user_already_logged_in, code)
            ErrorCodes.DEVICE_NOT_REGISTERED.toString() -> resourceRepository.getString(R.string.device_not_registered, code)
            ErrorCodes.ERROR_ON_INIT_USER.toString(),ErrorCodes.USER_NOT_MASTER_APPROVED.toString() -> resourceRepository.getString(
                            R.string.error_on_init_user, code)
            ErrorCodes.PIN_NOT_EXIST.toString() -> resourceRepository.getString(R.string.pin_code_not_exists, code)
            ErrorCodes.CREDENTIALS_WRONG.toString() -> resourceRepository.getString(R.string.credentials_wrong, code)
            ErrorCodes.PIN_EXPIRED.toString() -> resourceRepository.getString(R.string.pin_expired,code)
            ErrorCodes.NO_VALID_PIN.toString() -> resourceRepository.getString(R.string.no_valid_pin, code)
            ErrorCodes.USER_DOES_NOT_EXIST.toString() -> resourceRepository.getString(R.string.user_not_exist, code)
            ErrorCodes.USER_SUSPENDED.toString() -> resourceRepository.getString(R.string.user_suspended, code)
            ErrorCodes.KS_EXPIRED.toString() -> resourceRepository.getString(R.string.invalid_ks, code)
            else -> resourceRepository.getString(R.string.unexpected_error_auth, code)
        }
    }

}