package com.twentyfouri.tvlauncher.setupwizard.global

import android.view.inputmethod.EditorInfo
import android.widget.EditText

import androidx.databinding.BindingAdapter
import com.twentyfouri.tvlauncher.setupwizard.postcoresetup.OnActionDoneListener

object BindingAdapters {
    @BindingAdapter("onActionDone")
    @JvmStatic fun onActionDone(view: EditText, listener: OnActionDoneListener) {
        view.setOnEditorActionListener listener@{ _, actionId, _ ->
            if (actionId == EditorInfo.IME_ACTION_NEXT) {
                listener.onActionNext()
                return@listener true
            }
            else if (actionId == EditorInfo.IME_ACTION_DONE) {
                listener.onActionDone()
                return@listener true
            }
            false
        }
    }
}
